function [A] = groove_leak_area(N, t1, t2, area, tglow, tgup)
%This function evaluates Sealed Volumes connection area with backend groove
%INPUT:
% N : Number of contemporary Sealed Volumes
% t1 : angular coordinate of last tooth in contact w/ casing [deg]
% t2 : angular coordinate of first tooth in contact w/ casing [deg]
% area : total area of the backend groove [mm2]
% tglow : angular coordinate of the beginning of the backend groove [deg] 
% tgup :  angular coordinate of the end of the backend groove [deg]
%OUTPUT:
% A : length N vector containing the connection area to the backend groove 
%     of each Sealed Volume [mm2]

dt = tgup - tglow; %groove extension [deg]
A = zeros(N, 1); %initialize vector A
tt = t1 + (0:N).*(t2 - t1)/N; %angular position of each sealed tooth tip

%the following lines evaluate connection areas proceeding counterclockwise,
%starting from the last sealed volume to the first sealed volume
if area  ~= 0  %a backend groove exists
    for ii = 1 : N
        tlow = tt(ii); tup = tt(ii+1);
        if tlow < tglow && tup < tgup && tup > tglow, A(ii) = area*(tup-tglow)/dt;
        elseif  tlow <= tglow && tup >= tgup, A(ii) = area;
        elseif  tlow > tglow &&  tlow < tgup, A(ii) = area*(tgup-tlow)/dt;
        end 
    end
 A = flip(A); %vector A is flipped so that it returns connction areas from
              %the first sealed volume to the last sealed volume
end

end